var TagHelper = {
	init: function() {
		var contextMenu = document.getElementById("contentAreaContextMenu");
		contextMenu.addEventListener("popupshowing", this, false);
		Components.utils.import("resource://gre/modules/PluralForm.jsm");
	},
	destroy: function() {
		var contextMenu = document.getElementById("contentAreaContextMenu");
		contextMenu.removeEventListener("popupshowing", this, false);
	},
	generateTags: function() {
		var bundle = document.getElementById("taghelper-bundle");
		var url = window.content.location.href;
		url = PlacesUtils._uri(url);
		if (!PlacesUtils.bookmarks.isBookmarked(url)) {
			alert(bundle.getFormattedString("NOT_BOOKMARKED", [window.content.document.title]));
			return;
		}
		var keywords = [];
		var sel = window.content.getSelection();
		for (var i = 0; i < sel.rangeCount; i++) {
			var keyword = sel.getRangeAt(i).toString();
			keyword = keyword.replace(/^\s+|\s+$/g, "");
			keywords.push(keyword);
		}
		Application.console.log(bundle.getString("KEYWORDS") + " = " + keywords);
		if (keywords.length > 0) {
			PlacesUtils.tagging.tagURI(url, keywords);
		}
		sel.removeAllRanges();
		var numTags = keywords.length;
		var msg = PluralForm.get(numTags, bundle.getString("ADDED"));
		msg = msg.replace("#1", numTags);
		alert(msg + "\n" + keywords.join(", "));
	},
	handleEvent: function(event) {
		if (event.type == "popupshowing") {
			var selected = getBrowserSelection() != "";
			document.getElementById("taghelper-menu").hidden = !selected;
		}
	}
};

window.addEventListener("load", function() { TagHelper.init(); }, false);
window.addEventListener("unload", function() { TagHelper.destroy(); }, false);

